/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.compat;

import gravity_changer.api.GravityChangerAPI;
import gravity_changer.util.RotationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class GravityChangerInterface {
    public static Invoker invoker = new Invoker();
    private static boolean warned = false;

    @Environment(value=EnvType.CLIENT)
    private static void warnGravityChangerNotPresent() {
        if (!warned) {
            warned = true;
            CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.missing_gravity_changer").method_10852((class_2561)McHelper.getLinkText("https://modrinth.com/mod/gravity-api-fork")));
        }
    }

    public static class Invoker {
        public boolean isGravityChangerPresent() {
            return false;
        }

        public class_243 getEyeOffset(class_1297 entity) {
            return new class_243(0.0, (double)entity.method_5751(), 0.0);
        }

        public class_2350 getGravityDirection(class_1297 entity) {
            return class_2350.field_11033;
        }

        public class_2350 getBaseGravityDirection(class_1297 entity) {
            return class_2350.field_11033;
        }

        public void setClientPlayerGravityDirection(class_1657 player, class_2350 direction) {
            GravityChangerInterface.warnGravityChangerNotPresent();
        }

        public void setBaseGravityDirectionServer(class_1297 entity, class_2350 direction) {
        }

        @Nullable
        public DQuaternion getExtraCameraRotation(class_2350 gravityDirection) {
            return null;
        }

        public class_243 getWorldVelocity(class_1297 entity) {
            return entity.method_18798();
        }

        public void setWorldVelocity(class_1297 entity, class_243 newVelocity) {
            entity.method_18799(newVelocity);
        }

        public class_243 transformPlayerToWorld(class_2350 gravity, class_243 vec3d) {
            return vec3d;
        }

        public class_243 transformWorldToPlayer(class_2350 gravity, class_243 vec3d) {
            return vec3d;
        }

        public class_2350 transformDirPlayerToWorld(class_2350 gravity, class_2350 direction) {
            return direction;
        }

        public class_2350 transformDirWorldToPlayer(class_2350 gravity, class_2350 direction) {
            return direction;
        }
    }

    public static class OnGravityChangerPresent
    extends Invoker {
        @Override
        public boolean isGravityChangerPresent() {
            return true;
        }

        @Override
        public class_243 getEyeOffset(class_1297 entity) {
            return GravityChangerAPI.getEyeOffset((class_1297)entity);
        }

        @Override
        public class_2350 getGravityDirection(class_1297 entity) {
            return GravityChangerAPI.getGravityDirection((class_1297)entity);
        }

        @Override
        public class_2350 getBaseGravityDirection(class_1297 entity) {
            return GravityChangerAPI.getBaseGravityDirection((class_1297)entity);
        }

        @Override
        public void setBaseGravityDirectionServer(class_1297 entity, class_2350 direction) {
            GravityChangerAPI.setBaseGravityDirection((class_1297)entity, (class_2350)direction);
        }

        @Override
        public void setClientPlayerGravityDirection(class_1657 player, class_2350 direction) {
            this.setClientPlayerGravityDirectionClientOnly(player, direction);
        }

        @Environment(value=EnvType.CLIENT)
        private void setClientPlayerGravityDirectionClientOnly(class_1657 player, class_2350 direction) {
            Validate.isTrue((boolean)class_310.method_1551().method_18854());
            GravityChangerAPI.instantlySetClientBaseGravityDirection((class_1297)player, (class_2350)direction);
        }

        @Override
        @Nullable
        public DQuaternion getExtraCameraRotation(class_2350 gravityDirection) {
            if (gravityDirection == class_2350.field_11033) {
                return null;
            }
            return DQuaternion.fromMcQuaternion(RotationUtil.getWorldRotationQuaternion((class_2350)gravityDirection));
        }

        @Override
        public class_243 getWorldVelocity(class_1297 entity) {
            return GravityChangerAPI.getWorldVelocity((class_1297)entity);
        }

        @Override
        public void setWorldVelocity(class_1297 entity, class_243 newVelocity) {
            GravityChangerAPI.setWorldVelocity((class_1297)entity, (class_243)newVelocity);
        }

        @Override
        public class_243 transformPlayerToWorld(class_2350 gravity, class_243 vec3d) {
            return RotationUtil.vecPlayerToWorld((class_243)vec3d, (class_2350)gravity);
        }

        @Override
        public class_243 transformWorldToPlayer(class_2350 gravity, class_243 vec3d) {
            return RotationUtil.vecWorldToPlayer((class_243)vec3d, (class_2350)gravity);
        }

        @Override
        public class_2350 transformDirPlayerToWorld(class_2350 gravity, class_2350 direction) {
            return RotationUtil.dirPlayerToWorld((class_2350)direction, (class_2350)gravity);
        }

        @Override
        public class_2350 transformDirWorldToPlayer(class_2350 gravity, class_2350 direction) {
            return RotationUtil.dirWorldToPlayer((class_2350)direction, (class_2350)gravity);
        }
    }
}

